//+------------------------------------------------------------------+
//|                                            Murrey_Math_MT_VG.mq4 |
//|                       Copyright © 2004, Vladislav Goshkov (VG).  |
//|                                           4vg@mail.ru            |
//#property copyright "Vladislav Goshkov (VG)."
//#property link      "4vg@mail.ru"
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//|                               Copyright © 2020, Gehtsoft USA LLC |
//|                                            http://fxcodebase.com |
//+------------------------------------------------------------------+
//|                                      Developed by : Mario Jemic  |
//|                                           mario.jemic@gmail.com  |
//|                          https://AppliedMachineLearning.systems  |
//+------------------------------------------------------------------+
//|                                 Support our efforts by donating  |
//|                                  Paypal : https://goo.gl/9Rj74e  |
//|                                 Patreon : https://goo.gl/GdXWeN  |
//+------------------------------------------------------------------+
// https://forex-station.com/viewtopic.php?p=1295414498#p1295414498
// modified by banzai
// July 9th, 2020
// not for sale, rent, auction, nor lease

#property copyright "Copyright 2020, NickBixy"
#property link      "https://www.forexfactory.com/showthread.php?t=904734"
//#property version   "1.00"
#property strict

#property indicator_chart_window

enum pivotTypes
  {
   Standard,//Standard(Floor) Pivot Formula
   Fibonacci,//Fibonacci Pivot Formula
   Camarilla,//Camarilla Pivot Formula
   Woodie//Woodie Pivot Formula
  };

enum yesnoChoiceToggle
  {
   No,
   Yes
  };

input string Header="----------------- Pivot Point Settings------------------------------------------";//----- Pivot Point Settings
input pivotTypes pivotSelection=Standard;//Pivot Point Formula
input yesnoChoiceToggle drawFloorMidPP=No;//Draw Floor Mid Pivot Points?
input yesnoChoiceToggle showPriceLabel=No;//Show Price In Label?
input ENUM_TIMEFRAMES timeFrame=PERIOD_D1;//TimeFrame
input string Header2="----------------- Pivot Point Line/Label Customize Settings------------------------------------------";//----- Pivot Point Line/Label Customize Settings
input string customMSG="";//Custom Message Before Pivot Name
input yesnoChoiceToggle useShortLines=Yes;//Draw Short Lines
input int Line_Length=15;//Length of Short Line
input ENUM_LINE_STYLE lineStyle=STYLE_SOLID;//Line Style
input int lineWidth=1;//Line Width
input string Font="Arial";//Label Font
input int labelFontSize=9;//Label Font Size
input int ShiftLabel=10;//Label Shift +move right -move left
input yesnoChoiceToggle useSameColorLabelChoice=No;//Label use Same Color?
input color useSameColorLabelColor=clrWhite;//Label Color for Label use Same Color
input color resistantColor=clrDodgerBlue;//Resistant Line/Label Color
input color pivotColor=clrMagenta;//Pivot Line/Label Color
input color supportColor=clrRed;//Support Line/Label PP Color
input color midColor=clrGreen;//Mid PP Line/Label Color

//+------------------------------------------------------------------------------------------------------------------+
//template code start1
extern string             button_note1          = "------------------------------";
extern ENUM_BASE_CORNER   btn_corner            = CORNER_LEFT_UPPER; // chart btn_corner for anchoring
extern string             btn_text              = "PPL";
extern string             btn_Font              = "Arial";
extern int                btn_FontSize          = 10;                             //btn__font size
extern color              btn_text_color        = clrWhite;
extern color              btn_background_color  = clrDimGray;
extern color              btn_border_color      = clrBlack;
extern int                button_x              = 20;                                     //btn__x
extern int                button_y              = 13;                                     //btn__y
extern int                btn_Width             = 60;                                 //btn__width
extern int                btn_Height            = 20;                                //btn__height
extern string             button_note2          = "------------------------------";
bool                      show_data             = true;
string IndicatorName, IndicatorObjPrefix;
int WorkTime=0,Periods=0;
//template code end1


string indiName="PPL"+" "+EnumToString(pivotSelection)+" "+EnumToString(timeFrame);

string camarillaPivotNames[]=
  {
   "PP",
   "S1",
   "S2",
   "S3",
   "S4",
   "R1",
   "R2",
   "R3",
   "R4",
   "R5",
   "S5",
  };
double camarillaValueArray[11];
string standardPivotNames[]=
  {
   "PP",
   "S1",
   "S2",
   "S3",
   "R1",
   "R2",
   "R3",
   "R4",
   "S4",
   "MR4",
   "MR3",
   "MR2",
   "MR1",
   "MS1",
   "MS2",
   "MS3",
   "MS4",
  };
double standardValueArray[17];
string woodiePivotNames[]=
  {
   "PP",
   "S1",
   "S2",
   "R1",
   "R2",
   "S3",
   "S4",
   "R3",
   "R4",
  };
double woodieValueArray[9];
string fibonacciPivotNames[]=
  {
   "PP",
   "R38",
   "R61",
   "R78",
   "R100",
   "R138",
   "R161",
   "R200",
   "S38",
   "S61",
   "S78",
   "S100",
   "S138",
   "S161",
   "S200",
  };
double fibonacciValueArray[15];

//+------------------------------------------------------------------+
//template code start2
string GenerateIndicatorName(const string target) //don't change anything here
{
   string name = target;
   int try = 2;
   while (WindowFind(name) != -1)
   {
      name = target + " #" + IntegerToString(try++);
   }
   return name;
}
//+------------------------------------------------------------------+
class VisibilityCotroller //don't change anything here
{
   string buttonId;
   string visibilityId;
   bool show_data;
   bool recalc;
public:
   void Init(string id, string indicatorName, string caption, int x, int y) //don't change anything here
   {
      recalc = false;
      visibilityId = indicatorName + "_visibility";
      double val;
      if (GlobalVariableGet(visibilityId, val))
         show_data = val != 0;
         
      buttonId = id;
      ChartSetInteger(0, CHART_EVENT_MOUSE_MOVE, 1);
      createButton(buttonId, caption, btn_Width, btn_Height, btn_Font, btn_FontSize, btn_background_color, btn_border_color, btn_text_color);
      ObjectSetInteger(0,buttonId,OBJPROP_YDISTANCE, button_y);
      ObjectSetInteger(0,buttonId,OBJPROP_XDISTANCE, button_x);
// put init() here
      ObjectsDeleteAll(0,indiName,0,OBJ_TREND) ;
      ObjectsDeleteAll(0,indiName,0,OBJ_TEXT) ;

   }
//+------------------------------------------------------------------+
   void DeInit()
   {
      ObjectDelete(ChartID(), buttonId);
      //put deinit () here
      ObjectsDeleteAll(0,indiName,0,OBJ_TREND) ;
      ObjectsDeleteAll(0,indiName,0,OBJ_TEXT) ;
   }
//+------------------------------------------------------------------+
   bool HandleButtonClicks() //don't change anything here
   {
      if (ObjectGetInteger(0, buttonId, OBJPROP_STATE))
      {
         ObjectSetInteger(0, buttonId, OBJPROP_STATE, false);
         show_data = !show_data;
         GlobalVariableSet(visibilityId, show_data ? 1.0 : 0.0);
         recalc = true;
         return true;
      }
      return false;
   }
//+------------------------------------------------------------------+
   bool IsRecalcNeeded() //don't change anything here
   {
      return recalc;
   }
//+------------------------------------------------------------------+
   void ResetRecalc() //don't change anything here
   {
      recalc = false;
   }
//+------------------------------------------------------------------+
   bool IsVisible() //don't change anything here
   {
      return show_data;
   }
//+------------------------------------------------------------------+
private: //don't change anything here much
   void createButton(string buttonID,string buttonText,int width,int height,string font,int fontSize,color bgColor,color borderColor,color txtColor)
   {
      ObjectDelete    (0,buttonID);
      ObjectCreate    (0,buttonID,OBJ_BUTTON,0,0,0);
      ObjectSetInteger(0,buttonID,OBJPROP_COLOR,txtColor);
      ObjectSetInteger(0,buttonID,OBJPROP_BGCOLOR,bgColor);
      ObjectSetInteger(0,buttonID,OBJPROP_BORDER_COLOR,borderColor);
      ObjectSetInteger(0,buttonID,OBJPROP_BORDER_TYPE,BORDER_RAISED);
      ObjectSetInteger(0,buttonID,OBJPROP_XSIZE,width);
      ObjectSetInteger(0,buttonID,OBJPROP_YSIZE,height);
      ObjectSetString (0,buttonID,OBJPROP_FONT,font);
      ObjectSetString (0,buttonID,OBJPROP_TEXT,buttonText);
      ObjectSetInteger(0,buttonID,OBJPROP_FONTSIZE,fontSize);
      ObjectSetInteger(0,buttonID,OBJPROP_SELECTABLE,0);
      ObjectSetInteger(0,buttonID,OBJPROP_CORNER,btn_corner);
      ObjectSetInteger(0,buttonID,OBJPROP_HIDDEN,1);
   }
};
VisibilityCotroller visibility;
//+------------------------------------------------------------------+
int init()
  {
   IndicatorName = GenerateIndicatorName("PivotPointsLine");
   IndicatorObjPrefix = "__" + IndicatorName + "__";
   IndicatorShortName(IndicatorName);
   IndicatorDigits(Digits);
// Enter another different name below
   visibility.Init("show_hide_PivotPointsLine", IndicatorName, btn_text, button_x, button_y);

//DON'T put the init function here

   return 0;
};
//+------------------------------------------------------------------+
int deinit()  
  {
   visibility.DeInit();
    ObjectsDeleteAll(ChartID(), IndicatorObjPrefix);
    
    //put the deinit function here
    
   return(0);
  }
//+------------------------------------------------------------------+
void OnChartEvent(const int id, //don't change anything here
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
{
   if (visibility.HandleButtonClicks())
      start();
}
//+------------------------------------------------------------------+
//template end2
int start2()
  {
   if(pivotSelection==Camarilla)
     {
      camarillaPivotPoint(camarillaValueArray);
      for(int i=0; i<ArraySize(camarillaValueArray); i++)
        {
         DrawPivotLines(camarillaValueArray[i],camarillaPivotNames[i]);
        }
     }
   if(pivotSelection==Standard)
     {

      if(drawFloorMidPP==Yes)
        {
         standardPivotPoint(standardValueArray);
         for(int i=0; i<17; i++)
           {
            DrawPivotLines(standardValueArray[i],standardPivotNames[i]);
           }
        }
      else
        {
         standardPivotPoint(standardValueArray);
         for(int i=0; i<9; i++)
           {
            DrawPivotLines(standardValueArray[i],standardPivotNames[i]);
           }
        }

     }
   if(pivotSelection==Fibonacci)
     {
      fibonacciPivotPoint(fibonacciValueArray);
      for(int i=0; i<ArraySize(fibonacciValueArray); i++)
        {
         DrawPivotLines(fibonacciValueArray[i],fibonacciPivotNames[i]);
        }
     }
   if(pivotSelection==Woodie)
     {
      woodiePivotPoint(woodieValueArray);
      for(int i=0; i<ArraySize(woodieValueArray); i++)
        {
         DrawPivotLines(woodieValueArray[i],woodiePivotNames[i]);
        }
     }
   return 0;
  }
//+------------------------------------------------------------------+
int start()
{
//template start3
   visibility.HandleButtonClicks();
   visibility.ResetRecalc();
   
   if (visibility.IsVisible())
   {
//template end3

//now, put the start() here
   if(pivotSelection==Camarilla)
     {
      camarillaPivotPoint(camarillaValueArray);
      for(int i=0; i<ArraySize(camarillaValueArray); i++)
        {
         DrawPivotLines(camarillaValueArray[i],camarillaPivotNames[i]);
        }
     }
   if(pivotSelection==Standard)
     {

      if(drawFloorMidPP==Yes)
        {
         standardPivotPoint(standardValueArray);
         for(int i=0; i<17; i++)
           {
            DrawPivotLines(standardValueArray[i],standardPivotNames[i]);
           }
        }
      else
        {
         standardPivotPoint(standardValueArray);
         for(int i=0; i<9; i++)
           {
            DrawPivotLines(standardValueArray[i],standardPivotNames[i]);
           }
        }

     }
   if(pivotSelection==Fibonacci)
     {
      fibonacciPivotPoint(fibonacciValueArray);
      for(int i=0; i<ArraySize(fibonacciValueArray); i++)
        {
         DrawPivotLines(fibonacciValueArray[i],fibonacciPivotNames[i]);
        }
     }
   if(pivotSelection==Woodie)
     {
      woodiePivotPoint(woodieValueArray);
      for(int i=0; i<ArraySize(woodieValueArray); i++)
        {
         DrawPivotLines(woodieValueArray[i],woodiePivotNames[i]);
        }
     }

//template start4
      if( (WorkTime != Time[0]) || (Periods != Period()) ) 
      {
         if (show_data) // on button
         {
           start2();
         }
         else //off button
         {
      ObjectsDeleteAll(0,indiName,0,OBJ_TREND) ;
      ObjectsDeleteAll(0,indiName,0,OBJ_TEXT) ;
         }
      }
   }
   else //again, copy the off button function here
   {
      ObjectsDeleteAll(0,indiName,0,OBJ_TREND) ;
      ObjectsDeleteAll(0,indiName,0,OBJ_TEXT) ;
   }
//template end4  
   return(0);
}
//+---------------------------------------------------------------------+
void DrawPivotLines(double value,string pivotName)
  {
   color lineLabelColor=clrNONE;
   string message="Poop";
   if(showPriceLabel==Yes)
     {
      message=customMSG+pivotName+": "+DoubleToString(value,Digits);
     }
   else
     {
      message=customMSG+pivotName;
     }


   if('R'==StringGetChar(pivotName,0))
     {
      lineLabelColor=resistantColor;
     }
   else
      if('P'==StringGetChar(pivotName,0))
        {
         lineLabelColor=pivotColor;
        }
      else
         if('S'==StringGetChar(pivotName,0))
           {
            lineLabelColor=supportColor;
           }
         else
            if('M'==StringGetChar(pivotName,0))
              {
               lineLabelColor=midColor;
              }


   string nameLine=indiName+" "+EnumToString(pivotSelection)+EnumToString(timeFrame)+pivotName+" Line";
   string nameLabel=indiName+" "+EnumToString(pivotSelection)+EnumToString(timeFrame)+pivotName+" Label";
   if(ObjectFind(nameLine) != 0)
     {
      if(useShortLines==Yes)
        {
         ObjectCreate(nameLine, OBJ_TREND, 0, Time[1]+Period()*60, value, Time[0]+Period()*60*Line_Length, value);
         ObjectSet(nameLine,OBJPROP_RAY,false);
        }
      else
        {
         ObjectCreate(nameLine,OBJ_TREND,0,iTime(NULL,timeFrame,0),value,Time[0]+Period()*60,value);
         ObjectSet(nameLine,OBJPROP_RAY,true);
        }
      ObjectSet(nameLine,OBJPROP_COLOR,lineLabelColor);
      ObjectSet(nameLine,OBJPROP_STYLE,lineStyle);
      ObjectSet(nameLine,OBJPROP_WIDTH,lineWidth);
      ObjectSet(nameLine,OBJPROP_BACK,true);
      ObjectSet(nameLine,OBJPROP_SELECTED,false);
      ObjectSet(nameLine,OBJPROP_SELECTABLE,false);
     }
   else
     {
      if(useShortLines==Yes)
        {
         ObjectSet(nameLine,OBJPROP_RAY,false);
         ObjectMove(nameLine, 0, Time[1]+Period()*60, value);
         ObjectMove(nameLine, 1, Time[0]+Period()*60*Line_Length, value);
        }
      else
        {
         ObjectSet(nameLine,OBJPROP_RAY,true);
         ObjectMove(nameLine,0,iTime(NULL,timeFrame,0),value);
         ObjectMove(nameLine,1,Time[0]+Period()*60,value);
        }

     }
   if(ObjectFind(nameLabel) != 0)
     {
      ObjectCreate(nameLabel,OBJ_TEXT,0,Time[0]+Period()*60*ShiftLabel,value);
      if(useSameColorLabelChoice==Yes)
        {
         ObjectSetText(nameLabel,message,labelFontSize,Font,useSameColorLabelColor);
        }
      else
        {
         ObjectSetText(nameLabel,message,labelFontSize,Font,lineLabelColor);
        }
      ObjectSet(nameLabel,OBJPROP_BACK,true);
      ObjectSet(nameLabel,OBJPROP_SELECTED,false);
      ObjectSet(nameLabel,OBJPROP_SELECTABLE,false);
     }
   else
     {
      ObjectMove(nameLabel, 0,Time[0]+Period()*60*ShiftLabel,value);
      if(useSameColorLabelChoice==Yes)
        {
         ObjectSetText(nameLabel,message,labelFontSize,Font,useSameColorLabelColor);
        }
      else
        {
         ObjectSetText(nameLabel,message,labelFontSize,Font,lineLabelColor);
        }
     }
   ChartRedraw(0);
  }
//camarilla formula
void camarillaPivotPoint(double &ppArrayRef[])//camrilla pivot point formula
  {

   int shift=1;
   /*
   Returned value
   The zero-based day of week (0 means Sunday,1,2,3,4,5,6) of the specified date.
   */
   if(timeFrame==PERIOD_D1)
     {
      datetime dayCheck1=iTime(NULL,PERIOD_D1,shift);
      if(TimeDayOfWeek(dayCheck1) == 0)//found sunday
        {
         shift+=1;
        }

      datetime dayCheck2=iTime(NULL,PERIOD_D1,shift);
      if(TimeDayOfWeek(dayCheck2) == 6)//found saturday
        {
         shift+=1;
        }
     }

   double camRange= iHigh(NULL,timeFrame,shift)-iLow(NULL,timeFrame,shift);
   double prevHigh=iHigh(NULL,timeFrame,shift);
   double prevLow=iLow(NULL,timeFrame,shift);
   double prevClose=iClose(NULL,timeFrame,shift);
   int symbolDigits=(int)MarketInfo(NULL,MODE_DIGITS);
   double R1 = ((1.1 / 12) * camRange) + prevClose;
   double R2 = ((1.1 / 6) * camRange) + prevClose;
   double R3 = ((1.1 / 4) * camRange) + prevClose;
   double R4= ((1.1/2) * camRange)+prevClose;
   double S1= prevClose -((1.1/12) * camRange);
   double S2= prevClose -((1.1/6) * camRange);
   double S3 = prevClose - ((1.1 / 4) * camRange);
   double S4 = prevClose - ((1.1 / 2) * camRange);
   double PP = (R4+S4)/2;
   double R5=((prevHigh/prevLow)*prevClose);
   double S5=(prevClose-(R5-prevClose));
   ppArrayRef[0]=PP;
   ppArrayRef[1]=S1;
   ppArrayRef[2]=S2;
   ppArrayRef[3]=S3;
   ppArrayRef[4]=S4;
   ppArrayRef[5]=R1;
   ppArrayRef[6]=R2;
   ppArrayRef[7]=R3;
   ppArrayRef[8]=R4;
   ppArrayRef[9]=R5;
   ppArrayRef[10]=S5;
  }
//+------------------------------------------------------------------+
//standard pivot point formula
void standardPivotPoint(double &ppArrayRef[])//the formula for the standard floor pivot points
  {
   int shift=1;
   /*
   Returned value
   The zero-based day of week (0 means Sunday,1,2,3,4,5,6) of the specified date.
   */
   if(timeFrame==PERIOD_D1)
     {
      datetime dayCheck1=iTime(NULL,PERIOD_D1,shift);
      if(TimeDayOfWeek(dayCheck1) == 0)//found sunday - skip over
        {
         shift+=1;
        }

      datetime dayCheck2=iTime(NULL,PERIOD_D1,shift);
      if(TimeDayOfWeek(dayCheck2) == 6)//found saturday - skip over
        {
         shift+=1;
        }
     }

   double prevHigh = iHigh(NULL,timeFrame,shift);
   double prevLow=iLow(NULL,timeFrame,shift);
   double prevClose=iClose(NULL,timeFrame,shift);
   double PP = (prevHigh+prevLow+prevClose)/3;
   double R1 = (PP * 2)-prevLow;
   double S1 = (PP * 2)-prevHigh;
   double R2 = PP + prevHigh - prevLow;
   double S2 = PP - prevHigh + prevLow;
   double R3 = R1 + (prevHigh-prevLow);
   double S3 = prevLow - 2 * (prevHigh-PP);
   double R4 = R3+(R2-R1);
   double S4 = S3-(S1-S2);
   ppArrayRef[0]=PP;
   ppArrayRef[1]=S1;
   ppArrayRef[2]=S2;
   ppArrayRef[3]=S3;
   ppArrayRef[4]=R1;
   ppArrayRef[5]=R2;
   ppArrayRef[6]=R3;
   ppArrayRef[7]=R4;
   ppArrayRef[8]=S4;

   if(drawFloorMidPP==Yes)
     {
      //mid pivots
      ppArrayRef[9]=(R3+R4)/2;
      ppArrayRef[10]=(R2+R3)/2;
      ppArrayRef[11]=(R1+R2)/2;
      ppArrayRef[12]=(PP+R1)/2;
      ppArrayRef[13]=(PP+S1)/2;
      ppArrayRef[14]=(S1+S2)/2;
      ppArrayRef[15]=(S2+S3)/2;
      ppArrayRef[16]=(S3+S4)/2;
     }
  }
//+------------------------------------------------------------------+
void woodiePivotPoint(double &ppArrayRef[])//woodie pivot point formula
  {
   int shift=1;
   /*
   Returned value
   The zero-based day of week (0 means Sunday,1,2,3,4,5,6) of the specified date.
   */
   if(timeFrame==PERIOD_D1)
     {
      datetime dayCheck1=iTime(NULL,PERIOD_D1,shift);
      if(TimeDayOfWeek(dayCheck1) == 0)//found sunday
        {
         shift+=1;
        }

      datetime dayCheck2=iTime(NULL,PERIOD_D1,shift);
      if(TimeDayOfWeek(dayCheck2) == 6)//found saturday
        {
         shift+=1;
        }
     }

   double prevRange= iHigh(NULL,timeFrame,shift)-iLow(NULL,timeFrame,shift);
   double prevHigh = iHigh(NULL,timeFrame,shift);
   double prevLow=iLow(NULL,timeFrame,shift);
   double prevClose = iClose(NULL, timeFrame,shift);
   double todayOpen = iOpen(NULL, timeFrame,shift-1);
   double PP = (prevHigh+prevLow+(todayOpen*2))/4;
   double R1 = (PP * 2)-prevLow;
   double R2 = PP + prevRange;
   double S1 = (PP * 2)-prevHigh;
   double S2 = PP - prevRange;

   double S3 = (prevLow-2*(prevHigh-PP));
   double S4 = (S3-prevRange);

   double R3 = (prevHigh+2*(PP-prevLow));
   double R4 = (R3+prevRange);

   ppArrayRef[0]=PP;
   ppArrayRef[1]=S1;
   ppArrayRef[2]=S2;
   ppArrayRef[3]=R1;
   ppArrayRef[4]=R2;

   ppArrayRef[5]=S3;
   ppArrayRef[6]=S4;

   ppArrayRef[7]=R3;
   ppArrayRef[8]=R4;
  }
//fibonacci formula
void fibonacciPivotPoint(double &ppArrayRef[])//fibonacchi pivot point formula
  {

   int shift=1;
   /*
   Returned value
   The zero-based day of week (0 means Sunday,1,2,3,4,5,6) of the specified date.
   */

   if(timeFrame==PERIOD_D1)
     {
      datetime dayCheck1=iTime(NULL,PERIOD_D1,shift);
      if(TimeDayOfWeek(dayCheck1) == 0)//found sunday
        {
         shift+=1;
        }

      datetime dayCheck2=iTime(NULL,PERIOD_D1,shift);
      if(TimeDayOfWeek(dayCheck2) == 6)//found saturday
        {
         shift+=1;
        }
     }

   double prevRange= iHigh(NULL,timeFrame,shift)-iLow(NULL,timeFrame,shift);
   double prevHigh = iHigh(NULL,timeFrame,shift);
   double prevLow=iLow(NULL,timeFrame,shift);
   double prevClose=iClose(NULL,timeFrame,shift);
   double Pivot=(prevHigh+prevLow+prevClose)/3;
   double R38=  Pivot + ((prevRange) * 0.382);
   double R61=  Pivot + ((prevRange) * 0.618);
   double R78=  Pivot + ((prevRange) * 0.786);
   double R100= Pivot + ((prevRange) * 1.000);
   double R138= Pivot + ((prevRange) * 1.382);
   double R161= Pivot + ((prevRange) * 1.618);
   double R200= Pivot + ((prevRange) * 2.000);
   double S38 = Pivot - ((prevRange) * 0.382);
   double S61 = Pivot - ((prevRange) * 0.618);
   double S78 = Pivot -((prevRange)  * 0.786);
   double S100= Pivot - ((prevRange) * 1.000);
   double S138= Pivot - ((prevRange) * 1.382);
   double S161= Pivot - ((prevRange) * 1.618);
   double S200= Pivot - ((prevRange) * 2.000);
   ppArrayRef[0]=Pivot;
   ppArrayRef[1]=R38;
   ppArrayRef[2]=R61;
   ppArrayRef[3]=R78;
   ppArrayRef[4]=R100;
   ppArrayRef[5]=R138;
   ppArrayRef[6]=R161;
   ppArrayRef[7]=R200;
   ppArrayRef[8]=S38;
   ppArrayRef[9]=S61;
   ppArrayRef[10]=S78;
   ppArrayRef[11]=S100;
   ppArrayRef[12]=S138;
   ppArrayRef[13]=S161;
   ppArrayRef[14]=S200;
  }
//+------------------------------------------------------------------+
